﻿within ThermalSeparation.Media.Correlations;
package FugacityCoefficient
 /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 3.3 ***/

      /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 3.3 ***/
constant Real[:,:] leeKesler_Z1=
[0,      0.0100,0.0500,0.1000,0.2000,0.4000,0.6000,0.8000,1.0000,1.2000,1.5000,2.0000,3.0000,5.0000,7.0000,10.0000;
0.3000,-0.0008,-0.0040,-0.0081,-0.0161,-0.0323,-0.0484,-0.0645,-0.0806,-0.0966,-0.1207,-0.1608,-0.2407,-0.3996,-0.5572,-0.7915;
0.3500,-0.0009,-0.0046,-0.0093,-0.0185,-0.0370,-0.0554,-0.0738,-0.0921,-0.1105,-0.1379,-0.1834,-0.2738,-0.4523,-0.6279,-0.8863;
0.4000,-0.0010,-0.0048,-0.0095,-0.0190,-0.0380,-0.0570,-0.0758,-0.0946,-0.1134,-0.1414,-0.1879,-0.2799,-0.4603,-0.6365,-0.8936;
0.4500,-0.0009,-0.0047,-0.0094,-0.0187,-0.0374,-0.0560,-0.0745,-0.0929,-0.1113,-0.1387,-0.1840,-0.2734,-0.4475,-0.6162,-0.8606;
0.5000,-0.0009,-0.0045,-0.0090,-0.0181,-0.0360,-0.0539,-0.0716,-0.0893,-0.1069,-0.1330,-0.1762,-0.2611,-0.4253,-0.5831,-0.8099;
0.5500,-0.0314,-0.0043,-0.0086,-0.0172,-0.0343,-0.0513,-0.0682,-0.0849,-0.1015,-0.1263,-0.1669,-0.2465,-0.3991,-0.5446,-0.7521;
0.6000,-0.0205,-0.0041,-0.0082,-0.0164,-0.0326,-0.0487,-0.0646,-0.0803,-0.0960,-0.1192,-0.1572,-0.2312,-0.3718,-0.5047,-0.6928;
0.6500,-0.0137,-0.0772,-0.0078,-0.0156,-0.0309,-0.0461,-0.0611,-0.0759,-0.0906,-0.1122,-0.1476,-0.2160,-0.3447,-0.4653,-0.6346;
0.7000,-0.0093,-0.0507,-0.1161,-0.0148,-0.0294,-0.0438,-0.0579,-0.0718,-0.0855,-0.1057,-0.1385,-0.2013,-0.3184,-0.4270,-0.5785;
0.7500,-0.0064,-0.0339,-0.0744,-0.0143,-0.0282,-0.0417,-0.0550,-0.0681,-0.0808,-0.0996,-0.1298,-0.1872,-0.2929,-0.3901,-0.5250;
0.8000,-0.0044,-0.0228,-0.0487,-0.1160,-0.0272,-0.0401,-0.0526,-0.0648,-0.0767,-0.0940,-0.1217,-0.1736,-0.2682,-0.3545,-0.4740;
0.8500,-0.0029,-0.0152,-0.0319,-0.0715,-0.0268,-0.0391,-0.0509,-0.0622,-0.0731,-0.0888,-0.1138,-0.1602,-0.2439,-0.3201,-0.4254;
0.9000,-0.0019,-0.0099,-0.0205,-0.0442,-0.1118,-0.0396,-0.0503,-0.0604,-0.0701,-0.0840,-0.1059,-0.1463,-0.2195,-0.2862,-0.3788;
0.9300,-0.0015,-0.0075,-0.0154,-0.0326,-0.0763,-0.1662,-0.0514,-0.0602,-0.0687,-0.0810,-0.1007,-0.1374,-0.2045,-0.2661,-0.3516;
0.9500,-0.0012,-0.0062,-0.0126,-0.0262,-0.0589,-0.1110,-0.0540,-0.0607,-0.0678,-0.0788,-0.0967,-0.1310,-0.1943,-0.2526,-0.3339;
0.9700,-0.0010,-0.0050,-0.0101,-0.0208,-0.0450,-0.0770,-0.1647,-0.0623,-0.0669,-0.0759,-0.0921,-0.1240,-0.1837,-0.2391,-0.3163;
0.9800,-0.0009,-0.0044,-0.0090,-0.0184,-0.0390,-0.0641,-0.1100,-0.0641,-0.0661,-0.0740,-0.0893,-0.1202,-0.1783,-0.2322,-0.3075;
0.9900,-0.0008,-0.0039,-0.0079,-0.0161,-0.0335,-0.0531,-0.0796,-0.0680,-0.0646,-0.0715,-0.0861,-0.1162,-0.1728,-0.2254,-0.2989;
1.0000,-0.0007,-0.0034,-0.0069,-0.0140,-0.0285,-0.0435,-0.0588,-0.0879,-0.0609,-0.0678,-0.0824,-0.1118,-0.1672,-0.2185,-0.2902;
1.0100,-0.0006,-0.0030,-0.0060,-0.0120,-0.0240,-0.0351,-0.0429,-0.0223,-0.0473,-0.0621,-0.0778,-0.1072,-0.1615,-0.2116,-0.2816;
1.0200,-0.0005,-0.0026,-0.0051,-0.0102,-0.0198,-0.0277,-0.0308,-0.0062,0.0227,-0.0524,-0.0722,-0.1021,-0.1556,-0.2047,-0.2731;
1.0500,-0.0003,-0.0015,-0.0029,-0.0054,-0.0092,-0.0097,-0.0032,0.0220,0.1059,0.0451,-0.0432,-0.0838,-0.1370,-0.1835,-0.2476;
1.1000,0.0000,0.0000,0.0001,0.0007,0.0038,0.0106,0.0236,0.0476,0.0897,0.1630,0.0698,-0.0373,-0.1021,-0.1469,-0.2056;
1.1500,0.0002,0.0011,0.0023,0.0052,0.0127,0.0237,0.0396,0.0625,0.0943,0.1548,0.1667,0.0332,-0.0611,-0.1084,-0.1642;
1.2000,0.0004,0.0019,0.0039,0.0084,0.0190,0.0326,0.0499,0.0719,0.0991,0.1477,0.1990,0.1095,-0.0141,-0.0678,-0.1231;
1.3000,0.0006,0.0030,0.0061,0.0125,0.0267,0.0429,0.0612,0.0819,0.1048,0.1420,0.1991,0.2079,0.0875,0.0176,-0.0423;
1.4000,0.0007,0.0036,0.0072,0.0147,0.0306,0.0477,0.0661,0.0857,0.1063,0.1383,0.1894,0.2397,0.1737,0.1008,0.0350;
1.5000,0.0008,0.0039,0.0078,0.0158,0.0323,0.0497,0.0677,0.0864,0.1055,0.1345,0.1806,0.2433,0.2309,0.1717,0.1058;
1.6000,0.0008,0.0040,0.0080,0.0162,0.0330,0.0501,0.0677,0.0855,0.1035,0.1303,0.1729,0.2381,0.2631,0.2255,0.1673;
1.7000,0.0008,0.0040,0.0081,0.0163,0.0329,0.0497,0.0667,0.0838,0.1008,0.1259,0.1658,0.2305,0.2788,0.2628,0.2179;
1.8000,0.0008,0.0040,0.0081,0.0162,0.0325,0.0488,0.0652,0.0816,0.0978,0.1216,0.1593,0.2224,0.2846,0.2871,0.2576;
1.9000,0.0008,0.0040,0.0079,0.0159,0.0318,0.0477,0.0635,0.0792,0.0947,0.1173,0.1532,0.2144,0.2848,0.3017,0.2876;
2.0000,0.0008,0.0039,0.0078,0.0155,0.0310,0.0464,0.0617,0.0767,0.0916,0.1133,0.1476,0.2069,0.2819,0.3097,0.3096;
2.2000,0.0007,0.0037,0.0074,0.0147,0.0293,0.0437,0.0579,0.0719,0.0857,0.1057,0.1374,0.1932,0.2720,0.3135,0.3355;
2.4000,0.0007,0.0035,0.0070,0.0139,0.0276,0.0411,0.0544,0.0675,0.0803,0.0989,0.1285,0.1812,0.2602,0.3089,0.3459;
2.6000,0.0007,0.0033,0.0066,0.0131,0.0260,0.0387,0.0512,0.0634,0.0754,0.0929,0.1207,0.1706,0.2484,0.3009,0.3475;
2.8000,0.0006,0.0031,0.0062,0.0124,0.0245,0.0365,0.0483,0.0598,0.0711,0.0876,0.1138,0.1613,0.2372,0.2915,0.3443;
3.0000,0.0006,0.0029,0.0059,0.0117,0.0232,0.0345,0.0456,0.0565,0.0672,0.0828,0.1076,0.1529,0.2268,0.2817,0.3385;
3.5000,0.0005,0.0026,0.0052,0.0103,0.0204,0.0303,0.0401,0.0497,0.0591,0.0728,0.0949,0.1356,0.2042,0.2584,0.3194;
4.0000,0.0005,0.0023,0.0046,0.0091,0.0182,0.0270,0.0357,0.0443,0.0527,0.0651,0.0849,0.1219,0.1857,0.2378,0.2994];

  /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 3.2 ***/
constant Real[:,:] leeKesler_Z0=
[0,      0.0100,0.0500,0.1000,0.2000,0.4000,0.6000,0.8000,1.0000,1.2000,1.5000,2.0000,3.0000,5.0000,7.0000,10.0000;
0.3000,0.0029,0.0145,0.0290,0.0579,0.1158,0.1737,0.2315,0.2892,0.3470,0.4335,0.5775,0.8648,1.4366,2.0048,2.8507;
0.3500,0.0026,0.0130,0.0261,0.0522,0.1043,0.1564,0.2084,0.2604,0.3123,0.3901,0.5195,0.7775,1.2902,1.7967,2.5539;
0.4000,0.0024,0.0119,0.0239,0.0477,0.0953,0.1429,0.1904,0.2379,0.2853,0.3563,0.4744,0.7095,1.1758,1.6373,2.3211;
0.4500,0.0022,0.0110,0.0221,0.0442,0.0882,0.1322,0.1762,0.2200,0.2638,0.3294,0.4384,0.6551,1.0841,1.5077,2.1338;
0.5000,0.0021,0.0103,0.0207,0.0413,0.0825,0.1236,0.1647,0.2056,0.2465,0.3077,0.4092,0.6110,1.0094,1.4017,1.9801;
0.5500,0.9804,0.0098,0.0195,0.0390,0.0778,0.1166,0.1553,0.1939,0.2323,0.2899,0.3853,0.5747,0.9475,1.3137,1.6520;
0.6000,0.9849,0.0093,0.0186,0.0371,0.0741,0.1109,0.1476,0.1842,0.2207,0.2753,0.3657,0.5446,0.8959,1.2398,1.7440;
0.6500,0.9881,0.9377,0.0178,0.0356,0.0710,0.1063,0.1415,0.1765,0.2113,0.2634,0.3495,0.5197,0.8526,1.1773,1.6519;
0.7000,0.9904,0.9504,0.8958,0.0344,0.0687,0.1027,0.1366,0.1703,0.2038,0.2538,0.3364,0.4991,0.8161,1.1241,1.5729;
0.7500,0.9922,0.9598,0.9165,0.0336,0.0670,0.1001,0.1330,0.1656,0.1981,0.2464,0.3260,0.4823,0.7854,1.0787,1.5047;
0.8000,0.9935,0.9669,0.9319,0.8539,0.0661,0.0985,0.1307,0.1626,0.1942,0.2411,0.3182,0.4690,0.7598,1.0400,1.4456;
0.8500,0.9946,0.9725,0.9436,0.8810,0.0661,0.0983,0.1301,0.1614,0.1924,0.2382,0.3132,0.4591,0.7388,1.0071,1.3943;
0.9000,0.9954,0.9768,0.9528,0.9015,0.7800,0.1006,0.1321,0.1630,0.1935,0.2383,0.3114,0.4527,0.7220,0.9793,1.3496;
0.9300,0.9959,0.9790,0.9573,0.9115,0.8059,0.6635,0.1359,0.1664,0.1963,0.2405,0.3122,0.4507,0.7138,0.9648,1.3257;
0.9500,0.9961,0.9803,0.9600,0.9174,0.8206,0.6967,0.1410,0.1705,0.1998,0.2432,0.3138,0.4501,0.7092,0.9561,1.3108;
0.9700,0.9963,0.9815,0.9625,0.9227,0.8338,0.7240,0.5580,0.1779,0.2055,0.2474,0.3164,0.4504,0.7052,0.9480,1.2968;
0.9800,0.9965,0.9821,0.9637,0.9253,0.8398,0.7360,0.5887,0.1844,0.2097,0.2503,0.3182,0.4508,0.7035,0.9442,1.2901;
0.9900,0.9966,0.9826,0.9648,0.9277,0.8455,0.7471,0.6138,0.1959,0.2154,0.2538,0.3204,0.4514,0.7018,0.9406,1.2835;
1.0000,0.9967,0.9832,0.9659,0.9300,0.8509,0.7574,0.6353,0.2901,0.2237,0.2583,0.3229,0.4522,0.7004,0.9372,1.2772;
1.0100,0.9968,0.9837,0.9669,0.9322,0.8561,0.7671,0.6542,0.4648,0.2370,0.2640,0.3260,0.4533,0.6991,0.9339,1.2710;
1.0200,0.9969,0.9842,0.9679,0.9343,0.8610,0.7761,0.6710,0.5146,0.2629,0.2715,0.3297,0.4547,0.6980,0.9307,1.2650;
1.0500,0.9971,0.9855,0.9707,0.9401,0.8743,0.8002,0.7130,0.6026,0.4437,0.3131,0.3452,0.4604,0.6956,0.9222,1.2481;
1.1000,0.9975,0.9874,0.9747,0.9485,0.8930,0.8323,0.7649,0.6880,0.5984,0.4580,0.3953,0.4770,0.6950,0.9110,1.2232;
1.1500,0.9978,0.9891,0.9780,0.9554,0.9081,0.8576,0.8032,0.7443,0.6803,0.5798,0.4760,0.5042,0.6987,0.9033,1.2021;
1.2000,0.9981,0.9904,0.9808,0.9611,0.9205,0.8779,0.8330,0.7858,0.7363,0.6605,0.5605,0.5425,0.7069,0.8990,1.1844;
1.3000,0.9985,0.9926,0.9852,0.9702,0.9396,0.9083,0.8764,0.8438,0.8111,0.7624,0.6908,0.6344,0.7358,0.8998,1.1580;
1.4000,0.9988,0.9942,0.9884,0.9768,0.9534,0.9298,0.9062,0.8827,0.8595,0.8256,0.7753,0.7202,0.7761,0.9112,1.1419;
1.5000,0.9991,0.9954,0.9909,0.9818,0.9636,0.9456,0.9278,0.9103,0.8933,0.8689,0.8328,0.7887,0.8200,0.9297,1.1339;
1.6000,0.9993,0.9964,0.9928,0.9856,0.9714,0.9575,0.9439,0.9308,0.9180,0.9000,0.8738,0.8410,0.8617,0.9518,1.1320;
1.7000,0.9994,0.9971,0.9943,0.9886,0.9775,0.9667,0.9563,0.9463,0.9367,0.9234,0.9043,0.8809,0.8984,0.9745,1.1343;
1.8000,0.9995,0.9977,0.9955,0.9910,0.9823,0.9739,0.9659,0.9583,0.9511,0.9413,0.9275,0.9118,0.9297,0.9961,1.1391;
1.9000,0.9996,0.9982,0.9964,0.9929,0.9861,0.9796,0.9735,0.9678,0.9624,0.9552,0.9456,0.9359,0.9557,1.0157,1.1452;
2.0000,0.9997,0.9986,0.9972,0.9944,0.9892,0.9842,0.9796,0.9754,0.9715,0.9664,0.9599,0.9550,0.9772,1.0328,1.1516;
2.2000,0.9998,0.9992,0.9983,0.9967,0.9937,0.9910,0.9886,0.9865,0.9847,0.9826,0.9806,0.9827,1.0094,1.0600,1.1635;
2.4000,0.9999,0.9996,0.9991,0.9983,0.9969,0.9957,0.9948,0.9941,0.9936,0.9935,0.9945,1.0011,1.0313,1.0793,1.1728;
2.6000,1.0000,0.9998,0.9997,0.9994,0.9991,0.9990,0.9990,0.9993,0.9998,1.0010,1.0040,1.0137,1.0463,1.0926,1.1792;
2.8000,1.0000,1.0000,1.0001,1.0002,1.0007,1.0013,1.0021,1.0031,1.0042,1.0063,1.0106,1.0223,1.0565,1.1016,1.1830;
3.0000,1.0000,1.0002,1.0004,1.0008,1.0018,1.0030,1.0043,1.0057,1.0074,1.0101,1.0153,1.0284,1.0635,1.1075,1.1848;
3.5000,1.0001,1.0004,1.0008,1.0017,1.0035,1.0055,1.0075,1.0097,1.0120,1.0156,1.0221,1.0368,1.0723,1.1138,1.1834;
4.0000,1.0001,1.0005,1.0010,1.0021,1.0043,1.0066,1.0090,1.0115,1.0140,1.0179,1.0249,1.0401,1.0747,1.1136,1.1773];

                                                            /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 5.2 ***/
constant Real[:,:] leeKesler_residualEnthalpy0 = [
0.00,  0.010,  0.050,  0.100,  0.200,  0.400,  0.600,  0.800,  1.000,  1.200,  2.000,  5.000,  7.000,  10.000;
0.30,  6.045,  6.043,  6.040,  6.034,  6.022,  6.011,  5.999,  5.987,  5.975,  5.927,  5.748,  5.628,  5.446;
0.35,  5.906,  5.904,  5.901,  5.895,  5.882,  5.870,  5.858,  5.845,  5.833,  5.783,  5.595,  5.469,  5.278;
0.40,  5.763,  5.761,  5.757,  5.751,  5.738,  5.726,  5.713,  5.700,  5.687,  5.636,  5.442,  5.311,  5.113;
0.45,  5.615,  5.612,  5.609,  5.603,  5.590,  5.577,  5.564,  5.551,  5.538,  5.486,  5.288,  5.154,  4.950;
0.5,  5.465,  5.463,  5.459,  5.453,  5.440,  5.427,  5.414,  5.401,  5.388,  5.336,  5.135,  4.999,  4.791;
0.55,  0.032,  5.312,  5.309,  5.303,  5.290,  5.278,  5.265,  5.252,  5.239,  5.187,  4.986,  4.849,  4.638;
0.60,  0.027,   5.162,  5.159,  5.153,  5.141,  5.129,  5.116,  5.104,  5.091,  5.041,  4.842,  4.704,  4.492;
0.65,  0.023,  0.118,  5.008,  5.002,  4.991,  4.980,  4.968,  4.956,  4.945,  4.896,  4.702,  4.565,  4.353;
0.70,  0.020,  0.101,  0.213,  4.848,  4.838,  4.828,  4.818,  4.808,  4.797,  4.752,  4.566,  4.432,  4.221;
0.75,  0.017,  0.088,  0.183,  4.687,  4.679,  4.672,  4.664,  4.655,  4.646,  4.607,  4.434,  4.303,  4.095;
0.8,  0.015,  0.078,  0.160,  0.345,  4.507,  4.504,  4.499,  4.494,  4.488,  4.459,  4.303,  4.178,  3.974;
0.85,  0.014,  0.069,  0.141,  0.300,  4.309,  4.313,  4.316,  4.316,  4.316,  4.302,  4.173,  4.056,  3.857;
0.90,  0.012,  0.062,  0.126,  0.264,  0.596,  4.074,  4.094,  4.108,  4.118,  4.132,  4.043,  3.935,  3.744;
0.93,  0.011,  0.058,  0.118,  0.246,  0.545,  0.960,  3.920,  3.953,  3.976,  4.020,  3.963,  3.863,  3.678;
0.95,  0.011,  0.056,  0.113,  0.235,  0.516,  0.885,  3.763,  3.825,  3.865,  3.940,  3.910,  3.815,  3.634;
0.97,  0.011,  0.054,  0.109,  0.225,  0.490,  0.824,  1.356,  3.658,  3.732,  3.853,  3.856,  3.767,  3.591;
0.98,  0.01,  0.053,  0.107,  0.221,  0.478,  0.797,  1.273,  3.544,  3.652,  3.806,  3.829,  3.743,  3.569;
0.99,  0.010,  0.052,  0.105,  0.216,  0.466,  0.773,  1.206,  3.376,  3.558,  3.758,  3.801,  3.719,  3.546;
1.00,  0.010,  0.051,  0.103,  0.212,  0.455,  0.75,  1.151,  2.584,  3.441,  3.706,  3.774,  3.695,  3.526;
1.01,  0.01,  0.050,  0.101,  0.208,  0.445,  0.728,  1.102,  1.796,  3.283,  3.652,  3.746,  3.671,  3.505;
1.02,  0.010,  0.049,  0.099,  0.203,  0.434,  0.708,  1.060,  1.627,  3.039,  3.595,  3.718,  3.647,  3.484;
1.05,  0.009,  0.046,  0.094,  0.192,  0.407,  0.654,  0.955,  1.359,  2.034,  3.398,  3.632,  3.575,  3.420;
1.10,  0.008,  0.042,  0.086,  0.175,  0.367,  0.581,  0.827,  1.120,  1.487,  2.965,  3.484,  3.453,  3.315;
1.15,  0.008,  0.039,  0.079,  0.160,  0.334,  0.523,  0.732,  0.968,  1.239,  2.479,  3.329,  3.329,  3.211;
1.20,  0.007,  0.036,  0.073,  0.148,  0.305,  0.474,  0.657,  0.857,  1.076,  2.079,  3.166,  3.202,  3.107;
1.30,  0.006,  0.031,  0.063,  0.127,  0.259,  0.399,  0.545,  0.698,  0.860,  1.560,  2.825,  2.942,  2.899;
1.40,  0.005,  0.027,  0.055,  0.110,  0.224,  0.341,  0.463,  0.588,  0.716,  1.253,  2.486,  2.679,  2.692;
1.50,  0.005,  0.021,  0.048,  0.097,  0.196,  0.297,  0.4,  0.505,  0.611,  1.046,  2.175,  2.421,  2.486;
1.60,  0.004,  0.021,  0.043,  0.086,  0.173,  0.261,  0.350,  0.440,  0.531,  0.894,  1.904,  2.177,  2.285;
1.70,  0.004,  0.019,  0.038,  0.076,  0.153,  0.231,  0.309,  0.387,  0.466,  0.777,  1.672,  1.953,  2.091;
1.80,  0.003,  0.017,  0.034,  0.068,  0.137,  0.206,  0.275,  0.344,  0.413,  0.683,  1.476,  1.751,  1.908;
1.90,  0.003,  0.015,  0.031,  0.062,  0.123,  0.185,  0.246,  0.307,  0.368,  0.606,  1.309,  1.571,  1.736;
2.00,  0.003,  0.014,  0.028,  0.056,  0.111,  0.167,  0.222,  0.276,  0.330,  0.541,  1.167,  1.411,  1.577;
2.20,  0.002,  0.012,  0.023,  0.046,  0.092,  0.137,  0.182,  0.226,  0.269,  0.437,  0.937,  1.143,  1.295;
2.4,  0.002,  0.010,  0.019,  0.038,  0.076,  0.114,  0.150,  0.187,  0.222,  0.359,  0.761,  0.929,  1.058;
2.60,  0.002,  0.008,  0.016,  0.032,  0.064,  0.095,  0.125,  0.155,  0.185,  0.297,  0.621,  0.756,  0.858;
2.8,  0.001,  0.007,  0.014,  0.027,  0.054,  0.080,  0.105,  0.130,  0.154,  0.246,  0.508,  0.614,  0.689;
3.00,  0.001,  0.006,  0.011,  0.023,  0.045,  0.067,  0.088,  0.109,  0.129,  0.205,  0.415,  0.495,  0.545;
3.50,  0.001,  0.004,  0.007,  0.015,  0.029,  0.043,  0.056,  0.069,  0.081,  0.127,  0.239,  0.270,  0.264;
4.00,  0.000,  0.002,  0.005,  0.009,  0.017,  0.026,  0.033,  0.041,  0.048,  0.072,  0.116,  0.110,  0.061];

constant Real[:,:] leeKesler_residualEnthalpy1 = [
0.00,  0.010,  0.050,  0.100,  0.200,  0.400,  0.600,  0.800,  1.000,  1.200, 1.5, 2.000, 3,  5.000,  7.000,  10.000;
0.3,  11.098,11.096,11.095,11.091,11.083,11.076,11.069,11.062,11.055,11.044,11.027,10.992,10.935,10.872,10.781;
0.35, 10.656,10.655,10.654,10.653,10.65,10.646,10.643,10.64,10.637,10.632,10.624,10.609,10.581,10.554,10.529;
0.4,  10.121,10.121,10.121,10.12,10.121,10.121,10.121,10.121,10.121,10.121,10.122,10.123,10.128,10.135,10.15;
0.45,  9.515,9.515,9.516,9.517,9.519,9.521,9.523,9.525,9.527,9.531,9.537,9.549,9.576,9.611,9.663;
0.5,   8.868,8.869,8.87,8.872,8.876,8.88,8.864,8.888,8.892,8.899,8.909,8.932,8.978,9.03,9.111;
0.55,  0.08,8.211,8.212,8.215,8.221,8.226,8.232,8.238,8.243,8.252,8.267,8.298,8.36,8.425,8.531;
0.6,   0.059,7.568,7.57,7.573,7.579,7.585,7.591,7.596,7.603,7.614,7.632,7.669,7.745,7.824,7.95;
0.65,  0.045,0.247,6.949,6.952,6.959,6.966,6.973,6.98,6.987,6.997,7.017,7.059,7.147,7.239,7.381;
0.7,   0.034,0.185,0.415,6.36,6.367,6.373,6.381,6.388,6.395,6.407,6.429,6.475,6.574,6.677,6.837;
0.75,  0.027,0.142,0.306,5.796,5.802,5.809,5.816,5.824,5.832,5.845,5.868,5.918,6.027,6.142,6.318;
0.8,   0.021,0.11,0.234,0.542,5.266,5.271,5.278,5.285,5.293,5.306,5.33,5.385,5.506,5.632,5.824;
0.85,  0.017,0.087,0.182,0.401,4.753,4.734,4.758,4.763,4.771,4.784,4.81,4.872,5.008,5.149,5.358;
0.9,   0.014,0.07,0.144,0.308,0.751,4.254,4.248,4.249,4.255,4.268,4.298,4.371,4.53,4.688,4.916;
0.93,  0.012,0.061,0.126,0.265,0.612,1.236,3.942,3.934,3.937,3.951,3.987,4.073,4.251,4.422,4.662;
0.95,  0.011,0.056,0.115,0.241,0.542,0.994,3.737,3.712,3.713,3.73,3.773,3.873,4.068,4.248,4.497;
0.97,  0.01,0.052,0.105,0.219,0.483,0.837,1.616,3.47,3.467,3.492,3.551,3.67,3.885,4.077,4.336;
0.98,  0.01,0.05,0.101,0.209,0.457,0.776,1.324,3.332,3.327,3.363,3.434,3.568,3.795,3.992,4.257;
0.99,  0.009,0.048,0.097,0.2,0.433,0.722,1.154,3.164,3.164,3.223,3.313,3.464,3.705,3.909,4.178;
1,     0.009,0.046,0.093,0.191,0.41,0.675,1.034,2.471,2.952,3.065,3.186,3.358,3.615,3.825,4.1;
1.01,  0.009,0.044,0.089,0.183,0.389,0.632,0.94,1.375,2.595,2.88,3.051,3.251,3.525,3.742,4.023;
1.02,  0.008,0.042,0.085,0.175,0.37,0.594,0.863,1.18,1.723,2.65,2.906,3.142,3.435,3.661,3.947;
1.05,  0.007,0.037,0.075,0.153,0.318,0.498,0.691,0.877,0.878,1.496,2.381,2.8,3.167,3.418,3.722;
1.1,   0.006,0.03,0.061,0.123,0.251,0.381,0.507,0.617,0.673,0.617,1.261,2.167,2.72,3.023,3.362;
1.15,  0.005,0.025,0.05,0.099,0.199,0.296,0.385,0.459,0.503,0.487,0.604,1.497,2.275,2.641,3.019;
1.2,   0.004,0.02,0.04,0.08,0.158,0.232,0.297,0.349,0.381,0.381,0.361,0.934,1.84,2.273,2.692;
1.3,   0.003,0.013,0.026,0.052,0.1,0.142,0.177,0.203,0.218,0.218,0.178,0.3,1.066,1.592,2.086;
1.4,   0.002,0.008,0.016,0.032,0.06,0.063,0.1,0.111,0.115,0.108,0.07,0.044,0.504,1.012,1.547;
1.5,   0.001,0.005,0.009,0.018,0.032,0.042,0.048,0.049,0.046,0.032,-0.008,-0.078,0.142,0.556,1.08;
1.6,   0,0.002,0.004,0.007,0.012,0.013,0.011,0.005,-0.004,-0.023,-0.065,-0.151,-0.082,0.217,0.689;
1.7,   0,0,0,0,-0.003,-0.009,-0.017,-0.027,-0.04,-0.063,-0.109,-0.202,-0.223,-0.028,0.369;
1.8,   0,-0.001,-0.003,-0.006,-0.015,-0.025,-0.037,-0.051,-0.067,-0.094,-0.143,-0.241,-0.317,-0.203,0.112;
1.9,  -0.001,-0.003,-0.005,-0.011,-0.023,-0.037,-0.053,-0.07,-0.088,-0.117,-0.169,-0.271,-0.381,-0.33,-0.092;
2,    -0.001,-0.003,-0.007,-0.015,-0.03,-0.047,-0.065,-0.085,-0.105,-0.136,-0.19,-0.295,-0.428,-0.424,-0.255;
2.2,  -0.001,-0.005,-0.01,-0.02,-0.04,-0.062,-0.083,-0.106,-0.128,-0.163,-0.221,-0.331,-0.493,-0.551,-0.489;
2.4,  -0.001,-0.006,-0.012,-0.023,-0.047,-0.071,-0.095,-0.12,-0.144,-0.181,-0.242,-0.356,-0.535,-0.631,-0.645;
2.6,  -0.001,-0.006,-0.013,-0.026,-0.052,-0.078,-0.104,-0.13,-0.156,-0.194,-0.257,-0.376,-0.567,-0.687,-0.754;
2.8,  -0.001,-0.007,-0.014,-0.028,-0.055,-0.082,-0.11,-0.137,-0.164,-0.204,-0.269,-0.391,-0.591,-0.729,-0.836;
3,    -0.001,-0.007,-0.014,-0.029,-0.058,-0.086,-0.114,-0.142,-0.17,-0.211,-0.278,-0.403,-0.611,-0.763,-0.899;
3.5,  -0.002,-0.008,-0.016,-0.031,-0.062,-0.092,-0.122,-0.152,-0.181,-0.224,-0.294,-0.425,-0.65,-0.827,-1.015;
4,    -0.002,-0.008,-0.016,-0.032,-0.064,-0.096,-0.127,-0.158,-0.188,-0.233,-0.306,-0.442,-0.68,-0.874,-1.097];

        /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 5.6 ***/
constant Real[:,:] leeKesler_fugacityPressureRatio0=
[0, 0.01,  0.05,  0.1,  0.2,  0.4,  0.6,  0.8,  1.000,  1.200,  1.500,  2.000,  3.000,  5.000,  7.000,  10.000;
 0.3,  -3.708,  -4.402,  -4.696,  -4.985,  -5.261,  -5.412,  -5.512,  -5.584,  -5.638,  -5.697,  -5.759,  -5.810,  -5.782,  -5.679,  -5.461;
 0.35,  -2.471,  -3.166,  -3.461,  -3.751,  -4.029,  -4.183,  -4.285,  -4.359,  -4.416,  -4.479,  -4.547,  -4.611,  -4.608,  -4.530,  -4.352;
 0.4,  -1.566,  -2.261,  -2.557,  -2.848,  -3.128,  -3.283,  -3.387,  -3.463,  -3.522,  -3.588,  -3.661,  -3.735,  -3.752,  -3.694,  -3.545;
 0.45,  -0.879,  -1.575,  -1.871,  -2.162,  -2.444,  -2.601,  -2.707,  -2.785,  -2.845,  -2.913,  -2.990,  -3.071,  -3.104,  -3.063,  -2.938;
 0.5,  -0.344,  -1.040,  -1.336,  -1.628,  -1.912,  -2.070,  -2.177,  -2.256,  -2.317,  -2.387,  -2.468,  -2.555,  -2.601,  -2.572,  -2.468;
 0.55,  -0.008,  -0.614,  -0.911,  -1.204,  -1.488,  -1.647,  -1.755,  -1.835,  -1.897,  -1.969,  -2.052,  -2.145,  -2.201,  -2.183,  -2.096;
 0.6,  -0.007,  -0.269,  -0.566,  -0.859,  -1.144,  -1.304,  -1.413,  -1.494,  -1.557,  -1.630,  -1.715,  -1.812,  -1.878,  -1.869,  -1.795;
 0.65,  -0.005,  -0.026,  -0.283,  -0.576,  -0.862,  -1.023,  -1.132,  -1.214,  -1.278,  -1.352,  -1.439,  -1.539,  -1.612,  -1.611,  -1.549;
 0.7,  -0.004,  -0.021,  -0.043,  -0.341,  -0.627,  -0.789,  -0.899,  -0.981,  -1.045,  -1.120,  -1.208,  -1.312,  -1.391,  -1.396,  -1.344;
 0.75,  -0.003,  -0.017,  -0.035,  -0.144,  -0.430,  -0.592,  -0.703,  -0.785,  -0.850,  -0.925,  -1.015,  -1.121,  -1.204,  -1.215,  -1.172;
 0.80,  -0.003,  -0.014,  -0.029,  -0.059,  -0.264,  -0.426,  -0.537,  -0.619,  -0.685,  -0.760,  -0.851,  -0.958,  -1.046,  -1.062,  -1.026;
 0.85,  -0.002,  -0.012,  -0.024,  -0.049,  -0.123,  -0.285,  -0.396,  -0.479,  -0.544,  -0.620,  -0.711,  -0.819,  -0.911,  -0.930,  -0.901;
 0.90,  -0.002,  -0.010,  -0.020,  -0.041,  -0.086,  -0.166,  -0.276,  -0.359,  -0.424,  -0.500,  -0.591,  -0.700,  -0.794,  -0.817,  -0.793;
 0.93,  -0.002,  -0.009,  -0.018,  -0.037,  -0.077,  -0.122,  -0.214,  -0.296,  -0.361,  -0.437,  -0.527,  -0.637,  -0.732,  -0.756,  -0.735;
 0.95,  -0.002,  -0.008,  -0.017,  -0.035,  -0.072,  -0.113,  -0.176,  -0.258,  -0.322,  -0.398,  -0.488,  -0.598,  -0.693,  -0.719,  -0.699;
 0.97,  -0.002,  -0.008,  -0.016,  -0.033,  -0.067,  -0.105,  -0.148,  -0.223,  -0.287,  -0.362,  -0.452,  -0.561,  -0.657,  -0.683,  -0.665;
 0.98,  -0.002,  -0.008,  -0.016,  -0.032,  -0.065,  -0.101,  -0.142,  -0.206,  -0.270,  -0.344,  -0.434,  -0.543,  -0.639,  -0.666,  -0.649;
 0.99,  -0.001,  -0.007,  -0.015,  -0.031,  -0.063,  -0.098,  -0.137,  -0.191,  -0.254,  -0.328,  -0.417,  -0.526,  -0.622,  -0.649,  -0.633;
 1.00,  -0.001,  -0.007,  -0.015,  -0.030,  -0.061,  -0.095,  -0.132,  -0.176,  -0.238,  -0.312,  -0.401,  -0.509,  -0.605,  -0.633,  -0.617;
 1.01,  -0.001,  -0.007,  -0.014,  -0.029,  -0.059,  -0.091,  -0.127,  -0.168,  -0.224,  -0.297,  -0.385,  -0.493,  -0.589,  -0.617,  -0.602;
 1.02,  -0.001,  -0.007,  -0.014,  -0.028,  -0.057,  -0.088,  -0.122,  -0.161,  -0.210,  -0.282,  -0.370,  -0.477,  -0.573,  -0.601,  -0.588;
 1.05,  -0.001,  -0.006,  -0.013,  -0.025,  -0.052,  -0.080,  -0.110,  -0.143,  -0.180,  -0.242,  -0.327,  -0.433,  -0.529,  -0.557,  -0.546;
 1.10,  -0.001,  -0.005,  -0.011,  -0.022,  -0.045,  -0.069,  -0.093,  -0.120,  -0.148,  -0.193,  -0.267,  -0.368,  -0.462,  -0.491,  -0.482;
 1.15,  -0.001,  -0.005,  -0.009,  -0.019,  -0.039,  -0.059,  -0.080,  -0.102,  -0.125,  -0.160,  -0.220,  -0.312,  -0.403,  -0.433,  -0.426;
 1.20,  -0.001,  -0.004,  -0.008,  -0.017,  -0.034,  -0.051,  -0.069,  -0.088,  -0.106,  -0.135,  -0.184,  -0.266,  -0.352,  -0.382,  -0.377;
 1.30,  -0.001,  -0.003,  -0.006,  -0.013,  -0.026,  -0.039,  -0.052,  -0.066,  -0.080,  -0.100,  -0.134,  -0.195,  -0.269,  -0.296,  -0.293;
 1.40,  -0.001,  -0.003,  -0.005,  -0.010,  -0.020,  -0.030,  -0.040,  -0.051,  -0.061,  -0.076,  -0.101,  -0.146,  -0.205,  -0.229,  -0.226;
 1.50,  0.000,  -0.002,  -0.004,  -0.008,  -0.016,  -0.024,  -0.032,  -0.039,  -0.047,  -0.059,  -0.077,  -0.111,  -0.157,  -0.176,  -0.173;
 1.60,  0.000,  -0.002,  -0.003,  -0.006,  -0.012,  -0.019,  -0.025,  -0.031,  -0.037,  -0.046,  -0.060,  -0.085,  -0.120,  -0.135,  -0.129;
 1.70,  0.000,  -0.001,  -0.002,  -0.005,  -0.010,  -0.015,  -0.020,  -0.024,  -0.029,  -0.036,  -0.046,  -0.065,  -0.092,  -0.102,  -0.094;
 1.80,  0.000,  -0.001,  -0.002,  -0.004,  -0.008,  -0.012,  -0.015,  -0.019,  -0.023,  -0.028,  -0.036,  -0.050,  -0.069,  -0.075,  -0.066;
 1.90,  0.000,  -0.001,  -0.002,  -0.003,  -0.006,  -0.009,  -0.012,  -0.015,  -0.018,  -0.022,  -0.028,  -0.038,  -0.052,  -0.054,  -0.043;
 2.00,  0.000,  -0.001,  -0.001,  -0.002,  -0.005,  -0.007,  -0.099,  -0.012,  -0.014,  -0.017,  -0.021,  -0.029,  -0.037,  -0.037,  -0.024;
 2.20,  0.000,  0.000,  -0.001,  -0.001,  -0.003,  -0.004,  -0.005,  -0.007,  -0.018,  -0.009,  -0.012,  -0.015,  -0.017,  -0.012,  0.004;
 2.40,  0.000,  0.050,  0.000,  -0.001,  -0.001,  -0.002,  -0.003,  -0.003,  -0.004,  -0.004,  -0.005,  -0.006,  -0.003,  -0.005,  0.024;
 2.60,  0.000,  0.000,  0.000,  0.000,  0.000,  -0.001,  -0.001,  -0.001,  -0.001,  -0.001,  -0.001,  0.001,  0.007,  0.017,  0.037;
 2.80,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.001,  0.001,  0.001,  0.002,  0.003,  0.005,  0.014,  0.025,  0.046;
 3.00,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.002,  0.002,  0.003,  0.003,  0.005,  0.009,  0.018,  0.031,  0.053;
 3.50,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.003,  0.004,  0.005,  0.006,  0.008,  0.013,  0.025,  0.038,  0.061;
 4.00,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.004,  0.005,  0.006,  0.007,  0.010,  0.016,  0.028,  0.041,  0.064];

        /*** Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill: Tabelle 5.7 ***/
constant Real[:,:] leeKesler_fugacityPressureRatio1=
[0, 0.010,  0.050,  0.100,  0.200,  0.400,  0.600,  0.800,  1.000,  1.200,  1.500,  2.000,  3.000,  5.000,  7.000,  10.000;
 0.30,  -8.778,  -8.779,  -8.781,  -8.785,  -8.790,  -8.797,  -8.804,  -8.811,  -8.818,  -8.828,  -8.845,  -8.880,  -8.953,  -9.022,  -9.126;
 0.35,  -6.528,  -6.530,  -6.532,  -6.536,  -6.544,  -6.551,  -6.559,  -6.567,  -6.575,  -6.587,  -6.606,  -6.645,  -6.723,  -6.800,  -6.919;
 0.40,  -4.912,  -4.914,  -4.916,  -4.919,  -4.929,  -4.937,  -4.945,  -4.954,  -4.962,  -4.974,  -4.995,  -5.035,  -5.115,  -5.195,  -5.312;
 0.45,  -3.726,  -3.728,  -3.730,  -3.734,  -3.742,  -3.750,  -3.758,  -3.766,  -3.774,  -3.786,  -3.806,  -3.845,  -3.923,  -4.001,  -4.114;
 0.50,  -2.838,  -2.839,  -2.841,  -2.845,  -2.853,  -2.861,  -2.869,  -2.877,  -2.884,  -2.896,  -2.915,  -2.953,  -3.027,  -3.101,  -3.208;
 0.55,  -0.013,  -2.613,  -2.165,  -2.169,  -2.177,  -2.184,  -2.192,  -2.199,  -2.207,  -2.218,  -2.236,  -2.273,  -2.342,  -2.410,  -2.510;
 0.60,  -0.009,  -1.644,  -1.646,  -1.650,  -1.657,  -1.664,  -1.671,  -1.677,  -1.684,  -1.695,  -1.712,  -1.747,  -1.812,  -1.875,  -1.967;
 0.65,  -0.006,  -0.031,  -1.242,  -1.245,  -1.252,  -1.258,  -1.265,  -1.271,  -1.278,  -1.287,  -1.304,  -1.336,  -1.397,  -1.456,  -1.539;
 0.70,  -0.004,  -0.021,  -0.044,  -0.927,  -0.934,  -0.940,  -0.946,  -0.952,  -0.958,  -0.967,  -0.983,  -1.013,  -1.070,  -1.124,  -1.201;
 0.75,  -0.003,  -0.014,  -0.030,  -0.675,  -0.682,  -0.688,  -0.694,  -0.700,  -0.705,  -0.714,  -0.728,  -0.756,  -0.809,  -0.858,  -0.929;
 0.80,  -0.002,  -0.010,  -0.020,  -0.043,  -0.481,  -0.487,  -0.493,  -0.499,  -0.504,  -0.512,  -0.526,  -0.551,  -0.600,  -0.645,  -0.709;
 0.85,  -0.001,  -0.006,  -0.013,  -0.028,  -0.321,  -0.327,  -0.332,  -0.338,  -0.343,  -0.351,  -0.364,  -0.388,  -0.432,  -0.473,  -0.530;
 0.90,  -0.001,  -0.004,  -0.009,  -0.018,  -0.039,  -0.199,  -0.204,  -0.210,  -0.215,  -0.222,  -0.234,  -0.256,  -0.296,  -0.333,  -0.384;
 0.93,  -0.001,  -0.003,  -0.007,  -0.013,  -0.029,  -0.048,  -0.141,  -0.146,  -0.151,  -0.158,  -0.170,  -0.190,  -0.228,  -0.262,  -0.310;
 0.95,  -0.001,  -0.003,  -0.005,  -0.011,  -0.023,  -0.037,  -0.103,  -0.108,  -0.114,  -0.121,  -0.132,  -0.151,  -0.187,  -0.220,  -0.265;
 0.97,  0.000,  -0.002,  -0.004,  -0.009,  -0.018,  -0.029,  -0.042,  -0.075,  -0.080,  -0.087,  -0.097,  -0.116,  -0.149,  -0.180,  -0.223;
 0.98,  0.000,  -0.002,  -0.004,  -0.008,  -0.016,  -0.025,  -0.035,  -0.059,  -0.064,  -0.071,  -0.081,  -0.099,  -0.132,  -0.162,  -0.203;
 0.99,  0.000,  -0.002,  -0.003,  -0.007,  -0.014,  -0.021,  -0.030,  -0.044,  -0.050,  -0.056,  -0.066,  -0.084,  -0.115,  -0.144,  -0.184;
 1.00,  0.000,  -0.001,  -0.003,  -0.006,  -0.012,  -0.018,  -0.025,  -0.031,  -0.036,  -0.042,  -0.052,  -0.069,  -0.099,  -0.127,  -0.166;
 1.01,  0.000,  -0.001,  -0.003,  -0.005,  -0.010,  -0.016,  -0.021,  -0.024,  -0.024,  -0.030,  -0.038,  -0.054,  -0.084,  -0.111,  -0.149;
 1.02,  0.000,  -0.001,  -0.002,  -0.004,  -0.009,  -0.013,  -0.017,  -0.019,  -0.015,  -0.018,  -0.026,  -0.041,  -0.069,  -0.095,  -0.132;
 1.05,  0.000,  -0.001,  -0.001,  -0.002,  -0.005,  -0.006,  -0.007,  -0.007,  -0.002,  0.008,  0.007,  -0.005,  -0.029,  -0.052,  -0.085;
 1.10,  0.000,  0.000,  0.000,  0.000,  0.001,  0.002,  0.004,  0.007,  0.012,  0.025,  0.041,  0.042,  0.026,  0.008,  -0.019;
 1.15,  0.000,  0.000,  0.001,  0.002,  0.005,  0.008,  0.011,  0.016,  0.022,  0.034,  0.056,  0.074,  0.069,  0.057,  0.036;
 1.20,  0.000,  0.000,  0.002,  0.003,  0.007,  0.012,  0.017,  0.023,  0.029,  0.041,  0.064,  0.093,  0.102,  0.096,  0.081;
 1.30,  0.000,  0.000,  0.003,  0.005,  0.011,  0.017,  0.023,  0.030,  0.038,  0.049,  0.071,  0.109,  0.142,  0.150,  0.148;
 1.40,  0.000,  0.000,  0.003,  0.006,  0.013,  0.020,  0.027,  0.034,  0.041,  0.053,  0.074,  0.112,  0.161,  0.181,  0.191;
 1.50,  0.000,  0.000,  0.003,  0.007,  0.014,  0.021,  0.028,  0.036,  0.043,  0.055,  0.074,  0.112,  0.167,  0.197,  0.218;
 1.60,  0.000,  0.000,  0.003,  0.007,  0.014,  0.021,  0.029,  0.036,  0.043,  0.055,  0.074,  0.110,  0.167,  0.204,  0.234;
 1.70,  0.000,  0.000,  0.004,  0.007,  0.014,  0.021,  0.029,  0.036,  0.043,  0.054,  0.072,  0.107,  0.165,  0.205,  0.242;
 1.80,  0.000,  0.000,  0.003,  0.007,  0.014,  0.021,  0.028,  0.035,  0.042,  0.053,  0.070,  0.104,  0.161,  0.203,  0.246;
 1.90,  0.000,  0.000,  0.003,  0.007,  0.014,  0.021,  0.028,  0.034,  0.041,  0.052,  0.068,  0.101,  0.157,  0.200,  0.246;
 2.00,  0.000,  0.000,  0.003,  0.007,  0.013,  0.020,  0.027,  0.034,  0.040,  0.050,  0.066,  0.097,  0.152,  0.196,  0.244;
 2.20,  0.000,  0.000,  0.003,  0.006,  0.013,  0.019,  0.025,  0.032,  0.038,  0.047,  0.062,  0.091,  0.143,  0.186,  0.236;
 2.40,  0.000,  0.000,  0.003,  0.006,  0.012,  0.018,  0.024,  0.030,  0.036,  0.044,  0.058,  0.086,  0.134,  0.176,  0.227;
 2.60,  0.000,  0.000,  0.003,  0.006,  0.011,  0.017,  0.023,  0.028,  0.034,  0.042,  0.055,  0.080,  0.127,  0.167,  0.217;
 2.80,  0.000,  0.000,  0.003,  0.005,  0.011,  0.016,  0.021,  0.027,  0.032,  0.039,  0.052,  0.076,  0.120,  0.158,  0.208;
 3.00,  0.000,  0.000,  0.003,  0.005,  0.010,  0.015,  0.020,  0.025,  0.030,  0.037,  0.049,  0.072,  0.114,  0.151,  0.199;
 3.50,  0.000,  0.000,  0.002,  0.004,  0.009,  0.013,  0.018,  0.022,  0.026,  0.033,  0.043,  0.063,  0.101,  0.134,  0.179;
 4.00,  0.000,  0.000,  0.002,  0.004,  0.008,  0.012,  0.016,  0.020,  0.023,  0.029,  0.038,  0.057,  0.090,  0.121,  0.163];

  partial model BaseFugacityCoefficient "base model for fugacity coefficients"
    parameter Integer nS( min=1)= 2
                         annotation(Dialog(enable=false));

     input SI.Pressure p;
     input SI.Temperature T;
     input SI.MoleFraction y[nS];
     input SI.MolarVolume v;
     parameter SI.Temperature Tcrit[nS];
     parameter SI.Pressure pcrit[nS];
     parameter Real omega[nS];
     parameter SI.MolarVolume Vcrit[nS];
     parameter Units.DipoleMoment mu[nS];
    output Real phi[nS];

    Real phi_aux[nS];
  equation

  phi=phi_aux;
  end BaseFugacityCoefficient;

  model Cubic "cubic equation of state, after Redlich-Kwong"
  /*** z.B. Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill, p. 145 ***/
    extends BaseFugacityCoefficient;
    /*based on the redlich Kwong constants for cubic equations of state */

    parameter Real kij[nS,nS]= fill(0.01,nS,nS)
      "binary interaction coefficient for Redlich-Kwong equation";

    parameter Integer u=1 "nach Redlich Kwong Näherung";
    parameter Integer w=0 "nach Redlich Kwong Näherung";

  protected
    Real h[nS] "Hilfsvariable ohne phys. Bedeutung";
    Real h1[nS] "quotient aus bi/b";
    Real h2 "Hilfsvariable ohne phys. Bedeutung";
    Real delta[nS];

    Real Z(start=10) "Kompressionsfaktor";
    Real B "Mischkoeffizient";
    Real B1 "eigentlich B*";
    Real A1 "eigentlich A*";
    Real a[nS] "Konstanten nach Redlich Kwong für einzelne Komponenten";
    Real b[nS] "Konstanten nach Redlich Kwong für einzelne Komponenten";
    Real am "Konstanten a des Gemischs";
    Real bm "Konstanten b des Gemischs";
  Real test[nS];
  Real test1[nS];
  Real test2[nS];

  equation
      B=bm-(am/(Modelica.Constants.R*T));
      Z=1+((B*p/1e5)/(Modelica.Constants.R*T));
      B1=(bm*p/1e5)/(Modelica.Constants.R*T);
      A1=(am*p/1e5)/(Modelica.Constants.R^2*T^2);
      am=sum(sum((y[i]*y[j])*(a[i]*a[j])^(0.5)*(1-kij[i,j]) for i in 1:nS) for j in 1:nS);
      bm=sum(y[i]*b[i] for i in 1:nS);
      h2=sum(sum(y[j]*a[j]^(0.5)*(1-kij[k,j]) for j in 1:nS) for k in 1:nS);

      for i in 1:nS loop
        a[i]=  (0.42748*Modelica.Constants.R^2*Tcrit[i]^(2.5))/(T^(0.5)*
            pcrit[i]/1e5);
        b[i]=  0.08664*Modelica.Constants.R*Tcrit[i]/(pcrit[
            i]/1e5);

        h[i]=sum((y[ j]*Tcrit[j])/(pcrit[j]/1e5)         for j in 1:nS);

        h1[i]=(Tcrit[i]/(pcrit[i]/1e5))        /h[i];

        delta[i]=((2*a[i]^(0.5))/am)*h2;
  test[i] =  exp(h1[i]*(Z - 1) - Modelica.Math.log(max(1e-5,(Z - B1))) + (A1/(B1*sqrt(u^2
           - 4*w)))*(h1[i] - delta[i])*Modelica.Math.log(max(1e-5,((2*Z + B1*(u + sqrt(u^2 - 4*w)))/
          (2*Z + B1*(u - sqrt(u^2 - 4*w)))))));
  test1[i] = Z - B1;
  test2[i] = (2*Z + B1*(u + sqrt(u^2 - 4*w)))/(2*Z + B1*(u - sqrt(u^2 - 4*w)));
        phi_aux[i]=exp(h1[i]*(Z - 1) - Modelica.Math.log(max(1e-5,(Z - B1))) + (A1/(B1*sqrt(u^2
           - 4*w)))*(h1[i] - delta[i])*Modelica.Math.log(max(1e-5,((2*Z + B1*(u + sqrt(u^2 - 4*w)))/
          (2*Z + B1*(u - sqrt(u^2 - 4*w)))))));
      end for;

  end Cubic;

  model IdealGas "fugacity coefficient for ideal gas = 1"
    import ThermalSeparation;
    extends BaseFugacityCoefficient;

  equation
    phi_aux = ones(nS);
  end IdealGas;

  model LeeKesler
  /*Die Universelle Gaskonstante wird im folgenden in der Einheit [bar*cm3/mol*K] verwendet.
Daraus folgt der Faktor 10 für die Umrechnung aus [J/mol*K]. */
  /*Der Druck und der kritische Druck wird in [bar] verwendet. Die Eingaben sind in [Pa]. 
Es folgt ein Faktor 1e5 für die Umrechnung!*/
  /*Das Volumen wird in [cm3/mol] verwendet. Da die Eingaben in [m3/mol] sind, muss ein Faktor von 1e6 verwendet werden*/

  extends BaseFugacityCoefficient;
  //parameter Real kij_user[a]=fill(0.07,a);
  //parameter Real kij[nS,nS](fixed=false);
    parameter Real kij[nS,nS]= fill(0.07,nS,nS);
    //   parameter Integer a = inter[nS-1]
   //   "number of binary interaction parameters depending on the number of substances";

  /*Die Variablen y1-y6 sind Tabellenwerte, die nach dem ersten Durchlauf mit Hilfe von Trm und prm bestimmt werden müssen*/
  /*** Die Tabellennummern beziehen sich auf: Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, McGraw-Hill,
die Gleichungen sind in Tabelle 5-13 (S. 145) aufgelistet. ***/
    Real y1;
     //log (f/p)(0) aus Tabelle für reduzierte Temp und Druck des Gemischs!, Tabelle 5-6";
    Real y2;//=fill(0.0015,n) "=  {-0.014}
     // log (f/p)(1) aus Tabelle für reduzierte Temp und Druck des Gemischs!, Tabelle 5-7";
    Real y3;//=fill(0.01,n) "= {0.466} (H0-H/RTcm)0 aus Tabelle 5-2!";
    Real y4;//=fill(-0.001,n) "= {0.433} (H0-H/RTcm)1 aus Tabelle 5-3";
    Real y5;//=fill(0.998,n) "0.8455}
     // Z0 Zur Bestimmung des Kompressibiltäfaktors des Gemischs, Tabelle 3-2";
    Real y6;//=fill(0.001,n) "={-0.0335}
     // Z1 Zur Bestimmung des Kompressibiltätsfaktors des Gemischs, Tabelle 3-3";

    Real Tcm "[K]";
    Real pcm "[bar]";
    Real Zcm;
    Real Vcm(start=500) "[cm3/mol]";
    Real Vcij[nS,nS] "[cm3/mol]";
    Real Tcij[nS,nS] "[K]";
    Real Tr[nS] "reduzierte Werte der Komponenten";
    Real pr[nS];
    Real Trm "reduzierte Werte des Gemischs";
    Real prm;
    Real Zm "nach Glg 3-3.1";
    Real omegam(start=0);
    Real z4 "ln(f/P)m des Gemischs";
    Real z1 "H0-H/RTcm";
    Modelica.Blocks.Tables.CombiTable2D table_residualEnthalpy0( table = leeKesler_residualEnthalpy0);
    Modelica.Blocks.Tables.CombiTable2D table_residualEnthalpy1(table = leeKesler_residualEnthalpy1);
    Modelica.Blocks.Tables.CombiTable2D table_Z0(table = leeKesler_Z0);
    Modelica.Blocks.Tables.CombiTable2D table_Z1( table = leeKesler_Z1);
    Modelica.Blocks.Tables.CombiTable2D table_fugacityPressureRatio0(table = leeKesler_fugacityPressureRatio0);
    Modelica.Blocks.Tables.CombiTable2D table_fugacityPressureRatio1(table = leeKesler_fugacityPressureRatio1);

  protected
    Real z2[nS] "Erste Summe in Formel 5-8.16";
    Real z3[nS,nS] "Summe in Formel 5-8.17";
    Real z5[nS] "Zweite Summe in Formel 5-8.16";
    Real z6[nS] "d(omega)/(dy)";
    Real z7[nS,nS] "dT/dy nach Formel 5-8.17";
    Real z8[nS,nS] "dV/dy nach Formel 5-8.18";
    Real z9[nS,nS] "dP/dy nach Formel 5-8.19";

  // initial equation
  //    //Erstellen der kij Matrix:
  //      //Erstellen einer Matrix aus den binären Interaktionsparametern
  //       for i in 1:nS loop
  //         for m in i:nS loop
  //           if i==m then
  //             //die Einträge auf der Diagonalen, werden auf irgendeinen Wert gesetzt, da eh nie benutzt
  //             kij[i,m] = 0.07;
  //           else
  //             //die Einträge des Vektors werden an die richtigen Stellen auf der Matrix verteilt
  //             kij[i,m] = kij_user[m-2+i];
  //             end if;
  //           end for;
  //           for m in 1:i-1 loop
  //             //k_12 = k_21, k_13 = k_31 etc.
  //             kij[i,m] = kij[m,i];
  //           end for;
  //     end for;

  equation
    y3= table_residualEnthalpy0.y;
      table_residualEnthalpy0.u1 = Trm;
      table_residualEnthalpy0.u2 = prm;

    y4= table_residualEnthalpy1.y;
      table_residualEnthalpy1.u1 = Trm;
      table_residualEnthalpy1.u2 = prm;

    y5= table_Z0.y;
      table_Z0.u1 = Trm;
      table_Z0.u2 = prm;

    y6= table_Z1.y;
      table_Z1.u1 = Trm;
      table_Z1.u2 = prm;

    y1 = table_fugacityPressureRatio0.y;
     table_fugacityPressureRatio0.u1 = Trm;
     table_fugacityPressureRatio0.u2 = prm;

       y2 = table_fugacityPressureRatio1.y;
     table_fugacityPressureRatio1.u1 = Trm;
     table_fugacityPressureRatio1.u2 = prm;

    Zm=y5+omegam*y6;
    Trm=T/Tcm;
    prm=(p/1e5)/pcm;
    Zcm=0.2905-0.085*omegam;
    Tcm=(1/(Vcm^(1/4)))*(sum(sum(y[i]*y[j]*  Tcij[i,j]  * (Vcij[i,j])^(1/4) for i in 1:nS) for j in 1:nS));
    Vcm=sum(sum(y[i]*y[j]* Vcij[i,j] for i in 1:nS) for j in 1:nS);
    pcm=((0.2905-0.085*omegam)*10*Modelica.Constants.R*Tcm)/Vcm;
    omegam=sum(y[i]*omega[i] for i in 1:nS);
    z4=y1*Modelica.Math.log(10)+omegam*y2*Modelica.Math.log(10);
    z1=y3+omegam*y4;
    for i in 1:nS loop
      Tr[i]=T/Tcrit[i];
      pr[i]=p/pcrit[i];
      phi_aux[i]=exp(z4+(z1/T)*z2[i]+((Zm-1)/pcm)*z5[i]-(y2*Modelica.Math.log(10))*z6[i]);
      z2[i]=sum(if i==j then 0 else y[j]*z7[i,j] for j in 1:nS);
      z5[i]=sum(if i==j then 0 else y[j]*z9[i,j] for j in 1:nS);
      z6[i]=sum(if i==j then 0 else y[j]*(-omega[i]+omega[j]) for j in 1:nS);
      for j in 1:nS loop
        Vcij[i,j]= (1/8)*((Vcrit[i]*1e6)^(1/3)+(Vcrit[j]*1e6)^(1/3))^3;
        Tcij[i,j]= (Tcrit[i]*Tcrit[j])^(0.5)*(1-kij[i,j]); //eq. 5-6.29

        z3[i,j]=sum(y[l]*(Vcij[l,j]^(1/4)*Tcij[l,j]-Vcij[l,i]^(1/4)*Tcij[l,i]) for l in 1:nS);

        z7[i,j]=(2*z3[i,j]-(0.25/(Vcm^(3/4)))*z8[i,j]*Tcm)/(Vcm^(1/4));
        z8[i,j]=2*(sum(y[l]*Vcij[l,j]-Vcij[l,i] for l in 1:nS));
        z9[i,j]=pcm*(-(0.085*(omega[j]-omega[i])/Zcm)+(1/Tcm)*z7[i,j]-(1/Vcm)*z8[i,j]);
        end for;
    end for;

  end LeeKesler;

  model PengRobinson
                        //Lüdecke, Lüdecke, Thermodynamik S.566 / Mischungsgrößn: Gmehling & Kolbe Thermodynamik S43.
    extends BaseFugacityCoefficient;
   parameter Real kij[aux2]= fill(0.0267,aux2);
   final parameter Integer aux[:] = {1,3,6,10,15, 21, 28, 36, 45};
   final parameter Integer aux2 = aux[nS-1]
      "number of binary interaction coefficient for Redlich-Kwong equation depending on the number of substances";

  protected
    Real b; // Mischungsregel
    Real bi[nS]; // Reinstoffparameter

    Real a; //Gesamt a

    Real aik[nS,nS];// Kreuzkoeffizient

    Real alpha[nS];

    Real C[nS];
    Integer z;
    Real A[nS,nS] "matrix with the binary interaction coefficients";

  algorithm
  /*** construction of the matrix A using the vector a which is supplied by the user ***/
    for i in 1:nS loop
      for k in i:nS loop
        z:=z+1;
        if i==k then
           A[i,k]:=0;
           z:=z-1;
          else
           A[i,k]:=kij[z];
           A[k,i]:=A[i,k];
        end if;
      end for;
        end for;

  equation
  // i/k = Substanz

         for i in 1:nS loop
           for k in 1:nS loop
            if i == k then
             aik[i,k] = 0.45724*(Modelica.Constants.R^2)*(Tcrit[i]^2)/pcrit[i] * alpha[i];
            else

            aik[i,k] =(aik[i,i]*aik[k,k])^(0.5)*(1-A[i,k]);
            end if;
           end for;
         end for;

       for i in 1:nS loop
        C[i] = sum( y[k]*aik[k,i] for k in 1:nS);
       end for;

       for i in 1:nS loop
         alpha[i] = (1+(0.37464+1.54226*omega[i]-0.26992*omega[i]*omega[i])*(1-(T/Tcrit[i])^(0.5)))^2;
       end for;

   /*** Mischungsregeln (Van der Waals) ***/

     a = sum(sum( (y[i]*y[k]*aik[i,k]) for i in 1:nS) for k in 1:nS);
     b = sum((y[i]*bi[i]) for i in 1:nS);

   for i in 1:nS loop
     bi[i]=0.0778*(Modelica.Constants.R*Tcrit[i])/pcrit[i];
   end for;

     for i in 1:nS loop
           phi_aux[i] = exp( bi[i]/b * ( p*v/Modelica.Constants.R/T -1) - Modelica.Math.log(p*(v-b)/Modelica.Constants.R/T) - a/(2*sqrt(2)*b*Modelica.Constants.R*T) * (2*C[i]/a - bi[i]/b)*Modelica.Math.log( (v + (1+sqrt(2))*b)/(v+(1-sqrt(2))*b)));
     end for;

  end PengRobinson;

  model SoaveRedlichKwong
                          // Buch: Thermodynamik (Gmehling, Kolbe), S. 97 equ. 3.75, S. 43
    extends BaseFugacityCoefficient;

   final parameter Integer aux[:] = {1,3,6,10,15, 21, 28, 36, 45};
   final parameter Integer aux2 = aux[nS-1]
      "number of binary interaction coefficient for Redlich-Kwong equation depending on the number of substances";

    parameter Real kij[aux2]= fill(0.0267,aux2)
      "binary interaction coefficient for Redlich-Kwong equation";

  protected
    Real b; // Mischungsregel  [m3/mol]
    Real bi[nS]; // Reinstoffparameter

    Real a; //Gesamt a

    Real aik[nS,nS];// Kreuzkoeffizient

      // Reinstoffparameter [N*m^4/mol^2]
    Real alpha[nS];

    Real C[nS];

    Integer z;
   Real A[nS,nS] "matrix with the binary interaction coefficients";

  algorithm
  /*** construction of the matrix A using the vector kij which is supplied by the user ***/
     for i in 1:nS loop
       for k in i:nS loop
         z:=z+1;
         if i==k then
            A[i,k]:=0;
            z:=z-1;
           else
            A[i,k]:=kij[z];
            A[k,i]:=A[i,k];
         end if;
       end for;
      end for;

  equation
  // j = Stufe; i/k = Substanz

  // Druck in Pa und molares Volumen in m3/mol

      for i in 1:nS loop
        for k in 1:nS loop
         if i == k then
          aik[i,k] = 0.42748*((Modelica.Constants.R^2)*(Tcrit[i]^2))/(pcrit[i]) * alpha[i];
         else

         aik[i,k] =(aik[i,i]*aik[k,k])^(0.5)*(1-A[i,k]);
         end if;
        end for;
      end for;

  /*** Mischungsregeln ***/

    a = sum(sum( (y[i]*y[k]*aik[i,k]) for i in 1:nS) for k in 1:nS);

  for i in 1:nS loop
    bi[i]=0.08664*(Modelica.Constants.R*Tcrit[i])/(pcrit[i]);
  end for;

  b =sum((y[i]*bi[i]) for i in 1:nS);

      for i in 1:nS loop

         alpha[i] = (1+(0.48+1.574*omega[i]-0.176*omega[i]^2)*(1-((T/Tcrit[i])^(0.5))))^2;

         C[i] = sum( y[k]*aik[k,i] for k in 1:nS);

      phi_aux[i] =  exp( Modelica.Math.log(v/(v-b)) - (2*C[i]/(Modelica.Constants.R*T*b))*Modelica.Math.log((v+b)/v) + bi[i]/(v-b) - Modelica.Math.log((p)*v/(Modelica.Constants.R*T)) + (a*bi[i]/(Modelica.Constants.R*T*b^2))*(Modelica.Math.log((v+b)/v) - b/(v+b)));

      end for;

  end SoaveRedlichKwong;

  model TestModell

  parameter Integer nS = 2;

  parameter SI.Temperature T = 144.26;
  parameter SI.Pressure p = 100000;
  parameter SI.Pressure psat[nS] = {31090,72300};//,7214000};
  parameter SI.MolarVolume v = 0.044/1.7;
  parameter SI.MoleFraction y[nS] = {0.1,0.5};//,0.4}};

    replaceable package MediumVapour =
        ThermalSeparation.Media.IdealGasMixtures.N2_H2O;
        //für N2-CH4 Mischung: kij = 0.0267

   Virial virial(                     nS=2, T = T, p = p, y = y, v=v);

     ThermalSeparation.Media.Correlations.FugacityCoefficient.SoaveRedlichKwong
      SRK( nS=2, T = T, p = p, y = y, v=v);

    ThermalSeparation.Media.Correlations.FugacityCoefficient.PengRobinson PR(
       nS=2, T = T, p = p, y = y, v=v);

  end TestModell;

  model Virial
  /*** see for example Reid, Prausnitz: The Properties of Gases & Liquids, 4th edition, p. 145 and p. 79 ***/
   extends BaseFugacityCoefficient;

  /*** second virial coefficients for mixtures ***/

  parameter Integer NoOfEq[nS];

  ThermalSeparation.Media.Correlations.FugacityCoefficient.Virial_SecondVirialCoefficient
      svc(Tci=Tcrit, pci=pcrit, omega=omega, my=mu,Vci_m3_mol=Vcrit,
      nS=nS,
      T=T,
      NoOfEq=NoOfEq);

  protected
    Real Bij[nS,nS]=svc.B;
    Real B;
    Real Bi[nS];
    Real c[nS] "Hilfsvariable ohne physik. Bedeutung";

  equation
  /*** determination of the second virial coefficient ***/

    B=sum(sum(y[i]*y[j]*Bij[i,j] for i in 1:nS) for j in 1:nS);
    for i in 1:nS loop
      c[i]=sum(y[j]*Bij[i,j] for j in 1:nS);
      Bi[i]= 2*c[i]-B;
      phi_aux[i]=exp((p*Bi[i])/(Modelica.Constants.R*T));
    end for;

      annotation (Documentation(info="<html>
<p align=\"justify\"><h4>Virial Equation of State </h4></p>
<p>phi_vap ist durch die Gleichung</p>
<p><br/>phi_vap_i = exp [ 2*(sum(yj*Bij) - B) * P/ (R*T)]</p>
<p>gegeben. [2]</p>
<p>Bij sind die Virialkoeffizienten der Reinstoffe bzw. die sogenannten Cross-Koeffizienten.</p>
<p>Bei der Berechnung der Cross-Koeffizienten treten bin&auml;re Interaktionskoeffizienten auf. Diese sind oft nicht viel gr&ouml;&szlig;er/kleiner als 0.</p>
<p>Einige k&ouml;nnen in &QUOT;Fluid Phase Equilibria 260 (2007) 354-358&QUOT; nachgelesen werden.</p>
<p>Desweiteren werden f&uuml;r die Berechnung der Cross-Koeffizienten Mischungsgr&ouml;&szlig;en f&uuml;r Tcrit, pcrit, omega und vcrit ben&ouml;tigt.</p>
<p>Diese findet man in Lit [1, 5.10] oder in Lit[4].</p>
<p>Die Berechnung erfolgt mit Hilfe der Tsonopoulos Konstanten. Diese h&auml;ngen vom Dipolmoment ab. [1]</p>
<p>B ist der zweite Koeffizient der Virialgleichung und ergibt sich aus:</p>
<p><br/>B = sum(sum(yi*yj*Bij))</p>
<p><br/><br/>References:</p>
<p>[1] Poling, Prausnitz, O&apos;Connell : The Properties of Gases &AMP; Liquids 5th Edition [4.13, 5.10]</p>
<p>[2] Gmehling, Kolbe: Thermodynamik [p. 120]</p>
<p>[3] Dymond, Smith : The Virial Coefficients of Pure Gases and Mixtures</p>
<p>[4] Fluid Phase Equilibria 260 (2007) 354-358</p>
</html>"));
  end Virial;

  model Virial_SecondVirialCoefficient
                                       // Properties of Gases & Liquids 5th Ed. (4.13, 5.10)

      parameter Integer nS=2 "number of components";

    parameter SI.Temperature Tci[nS];
    parameter SI.Pressure pci[nS];
    parameter Units.DipoleMoment my[nS];
    parameter Real omega[nS];

    parameter SI.MolarVolume Vci_m3_mol[nS]
      "Vektor der kritischen Volumina in m3/mol";
    input SI.Temperature T "[K]";
    input Integer NoOfEq[nS];

    output Real B[nS,nS] "in m³/mol";

    Virial_TsonopoulosConstants TsonopoulosConstants(Tcrit=Tci, pcrit=pci,my=my,
  nS=nS,  NoOfEq=NoOfEq);

  protected
    Real Vci[nS] = Vci_m3_mol*1e6 "critical molar volumina in cm3/mol";
    Real Zci[nS] "compressibility factors at the critical point";
    Real kij[nS,nS];
    Real Tcik[nS,nS];
    Real Vcik[nS,nS];
    Real pcik[nS,nS];
    Real Zcik[nS,nS];
    Real omegaik[nS,nS];
    Real Tr[nS,nS];
    Real aik[nS,nS];
    Real bik[nS,nS];
    Real f0[nS,nS];
    Real f1[nS,nS];
    Real f2[nS,nS];
    Real f3[nS,nS];
    Real Summe[nS,nS];

  //Tsonopoulos Parameter für 2ten Virialkoeff.
    Real ai[nS]= TsonopoulosConstants.a;
    Real bi[nS]= TsonopoulosConstants.b;

  equation
  for i in 1: nS loop
    Zci[i] = pci[i]*Vci_m3_mol[i]/Modelica.Constants.R/Tci[i];
  end for;

  for i in 1:nS loop
    for k in 1:nS loop
      if i==k then
              Tcik[i,k]=  Tci[i];
          Vcik[i,k]=  Vci_m3_mol[i];
          pcik[i,k]= pci[i];
          Zcik[i,k]= Zci[i];
          omegaik[i,k]= omega[i];
          kij[i,k]= 0;
          aik[i,k] = ai[i];
          bik[i,k] = bi[i];
      else
                Vcik[i,k]=   ((Vci_m3_mol[i]^(1/3)+Vci_m3_mol[k]^(1/3))/2)^3;
          Zcik[i,k]=   (Zci[i]+Zci[k])/2;

          Tcik[i,k]=   (Tci[i]*Tci[k])^(1/2)*(1-kij[i,k]);
          pcik[i,k]=   Zcik[i,k]*Modelica.Constants.R*Tcik[i,k]/Vcik[i,k];
          omegaik[i,k]=   (omega[i]+omega[k])/2;

          if my[i]== 0 and my[k] == 0 then
            kij[i,k]=   1-((2*(Vci[i]*Vci[k])^(1/6))  /  (Vci[i]^(1/3)+Vci[k]^(1/3))^3);
          else
            kij[i,k] = 0.154;
          end if;

          if my[i]== 0 or my[k] == 0 then
            aik[i,k] = 0;
            bik[i,k] = 0;
          else
            aik[i,k]= (ai[i]+ai[k])/2;
            bik[i,k]= (bi[i]+bi[k])/2;
          end if;
          end if;
          end for;
          end for;

    for i in 1:nS loop
      for k in 1:nS loop

          f0[i,k] = 0.1445-0.330/Tr[i,k]-0.1385/Tr[i,k]^2-0.0121/Tr[i,k]^3-0.000607/Tr[i,k]^8;
          f1[i,k] = 0.0637+0.331/Tr[i,k]^2-0.423/Tr[i,k]^3-0.008/Tr[i,k]^8;
          f2[i,k] = 1/Tr[i,k]^6;
          f3[i,k] = -1/Tr[i,k]^8;

          Summe[i,k] = f0[i,k] + omegaik[i,k]*f1[i,k]+aik[i,k]*f2[i,k]+bik[i,k]*f3[i,k];

        if i==k then

          Tr[i,k]=  T/Tci[i];
          B[i,k] = Modelica.Constants.R*Tci[i]/pci[i]*Summe[i,k] "in m³/mol";
          //Bij[i,j]= ((0.083-(0.422/Tr[i,j]^(1/6)))+omega[i]*(0.139-(0.172/Tr[i,j]^(4.2))))*(Modelica.Constants.R*Tci[i])/pci[i];
        else

          Tr[i,k]=  T/Tcik[i,k];

          B[i,k] = Modelica.Constants.R*Tcik[i,k]/pcik[i,k]*Summe[i,k]
            "in m³/mol";

          //Bij[i,j]= ((0.083-(0.422/Tr[i,j]^(1/6)))+omegaij[i,j]*(0.139-(0.172/Tr[i,j]^(4.2))))*(Modelica.Constants.R*Tcij[i,j])/pcij[i,j];
        end if;
      end for;

    end for;

  end Virial_SecondVirialCoefficient;

  model Virial_TsonopoulosConstants
                                              // Properties of Gases & Liquids 4.15

  parameter Integer nS=2;
  input Integer NoOfEq[nS];
  parameter SI.Temperature Tcrit[nS];
  parameter SI.Pressure pcrit[nS];
  parameter Units.DipoleMoment my[nS];

  parameter Real a[nS](each fixed = false);
  parameter Real b[nS](each fixed = false);

  protected
  parameter Real my_r[nS](each fixed = false);
  parameter Real pcrit_atm[nS](each fixed = false);
  initial equation
  for m in 1:nS loop

  pcrit_atm[m] = pcrit[m]*9.8692*1e-6;

  my_r[m] = 10^5*my[m]^2 * pcrit_atm[m]/Tcrit[m]^2;

    if NoOfEq[m] == 1 then
                   a[m] = 0;
                   b[m] = 0; else
      if NoOfEq[m] == 2 then
                     a[m] = -2.14 * 10^(-4)*my_r[m] - 4.308 * 10^(-21)*my_r[m]^8;
                     b[m] = 0;                                                    else
        if NoOfEq[m] == 3 then
                       a[m] = -2.188 * 10^(-4) * my_r[m]^4 - 7.831 * 10^(-21) * my_r[m]^8;
                       b[m] = 0;                                                           else
          if NoOfEq[m] == 4 then
                         a[m] = 0.0878;
                         b[m] = 0.00908 + 0.0006957*my_r[m];
                                        else
            if NoOfEq[m] == 5 then
                           a[m] = 0.0878;
                           b[m] = 0.0525; else

                             a[m] = -0.0109;
                             b[m] = 0;

            end if;
          end if;
        end if;
      end if;
    end if;
  end for;
    annotation (Documentation(info="<html>
<p><h4>Tsonopoulos Constants for Second Virial Coefficient</h4></p>
<p><u>Literature:</u> Properties of Gases &AMP; Liquids 5th Edition ( 4.13, 5.10)</p>
<p>Equation for estimation of a and b can be found in the above mentioned Literature. </p>
<p><br/>mu_r = 10^5 * mu^2 *pcrit / Tcrit^2</p>
<p><ul>
<li>mu [ debye]</li>
<li>pcrit [atm]</li>
<li>Tcrit[K]</li>
</ul></p>
</html>"));
  end Virial_TsonopoulosConstants;
  annotation (Documentation(info="<html>
<p><h4><font color=\"#008000\">Vapour Phase</font></h4></p>
<p>The fugacitiy coefficient can be calculated using different equations of state. This package contains some of these equations of state.</p>
<p><u><font style=\"color: #008000; \">Virial equation of state</font></u></p>
<p><i>phi_vap</i> is given by</p>
<p><ul>
<li>phi_vap_i = exp [ 2*(sum(yj*Bij) - B) * P/ (R*T)]. </li>
</ul></p>
<p><br/><i>Bij</i> are the virial coefficients for pure components(if i=j) and the cross-coefficients(if i!=j) , they can be either taken out of adequate literature, such as (Lit. [3]), or calculated with the correlations of <b>Tsonopoulos</b> (1974) (Lit. [1], 4.13, 5.10). </p>
<p>If the <b>cross-coefficients</b> are calculated, there are binary interaction coefficients kij in the mixing rule for the temperature. These binary constants are more or less between 1 and -1, just for giving an approximate range. The mixing rules are shown in (Lit.[1], 5.10; Lit.[4]). For the existing media models these constants are given and can be accessed just like other constants for instance the critical data. Additional data is given in (Lit. [4]).</p>
<p>For the Tsonopoulos correlation two specific substance constants are needed. They are a function of the critical data and the dipole moment, which is also given in the media package. For further calculations beyond the existing media models, a vector (eq_Tsonopoulos) has to be implemented, which refer on the necessary equations. The equations for the Tsonopoulos constants are shown in (Lit[1], 4.15).</p>
<p><u><font style=\"color: #008000; \">Soave-Redlich-Kwong(SRK)</font></u></p>
<p><br/>The Soave-Redlich-Kwong equation of state depends on two interaction parameters. The parameters are computed with the critical data and one of them has a temperature dependence. Furthermore for mixtures there are special relations. There is one further binary interaction parameter kij, which occur in the mixing rule for the cross coefficient aij. Some of these binary parameters are listed in (Lit. [4]). For the existing media models these parameters are accessable like the critical data.</p>
<p>The used mixing rules are the Van-der-Waals mixing rules, as it is recommanded in the literature.</p>
<p><u><font style=\"color: #008000; \">Peng-Robinson(PR)</font></u></p>
<p><br/>The Peng-Robinson equation of state differs just a little from the SRK. The application of the PR EoS is similar to the SRK.</p>
<p><br/><u><font style=\"color: #008000; \">References:</font></u></p>
<p>[1] Poling, Prausnitz, O&apos;Connell : The Properties of Gases &AMP; Liquids 5th Edition [4.13, 5.10]</p>
<p>[2] Gmehling, Kolbe: Thermodynamik</p>
<p>[3] Dymond, Smith : The Virial Coefficients of Pure Gases and Mixtures</p>
<p>[4] Fluid Phase Equilibria 260 (2007) 354-358</p>
</html>"));
end FugacityCoefficient;
